//The DIY Life
//Michael Klements
//9 July 2020

int ledSignal = 14;                               //Assign the LED pin
int shutterPin = 15;                              //Assign the optocoupler pin number
int triggerPin = 0;                               //Assign the LDR analog pin number
int triggerPointPin = 1;                          //Assign the trigger setpoint analog pin number
int delayValPin =2;                               //Assign the delay setpoint analog pin number
int triggered =0;                                 //Variable to store the LDR reading
int triggerPoint = 0;                             //Variable to store the trigger setpoint
int delayVal = 0;                                 //Variable to store the delay setpoint


#include <SPI.h>                                  //Include the libraries to control the OLED display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);             //Create the display object

void setup() 
{ 
  Serial.begin(9600);                             //Start serial communication (only required for debugging)
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);      //Connect to the display
  display.clearDisplay();                         //Clear the display
  display.setTextColor(WHITE);                    //Set the text colour to white
  pinMode(shutterPin,OUTPUT);                     //Define the shutter release pin mode
  pinMode(ledSignal,OUTPUT);                      //Define the LED pin mode
  digitalWrite(shutterPin,LOW);                   //Set the shutter pin to low / off
}
 
void loop() 
{ 
  triggerPoint = analogRead(triggerPointPin);     //Read in the trigger setpoint
  triggered = analogRead(triggerPin);             //Read in the current LDR level
  delayVal = analogRead(delayValPin);             //Read in the delay setpoint
  display.clearDisplay();                         //Display the read in values on the OLED display
  display.setCursor(0,0);
  display.print(triggerPoint);
  display.setCursor(23,0);
  display.println("Trigger Setpoint");
  display.setCursor(0,15);
  display.print(triggered);
  display.setCursor(23,15);
  display.println("LDR Reading");
  display.setCursor(0,30);
  display.print(delayVal);
  display.setCursor(23,30);
  display.println("Delay (ms)");
  display.display();
  Serial.println("A1-Trigger Setpoint");          //Display the read in values on the serial monitor
  Serial.println(triggerPoint);                           //Can be removed after debugging
  Serial.println("A0-LDR Reading");   
  Serial.println(triggered);
  Serial.println("A2-Delay (ms)"); 
  Serial.println(delayVal);
  if (triggered >= triggerPoint)                  //If measured light is higher than the setpoint
  {
    delay(delayVal);                              //Wait the delay time for lightning to be the brightest
    digitalWrite(shutterPin,HIGH);                //Trigger camera
    digitalWrite(ledSignal,HIGH);                 //Light up the LED
    delay(1000);                                  //Wait one second, avoids retriggering if lighting is still bright
    digitalWrite(shutterPin,LOW);                 //Release the trigger
    digitalWrite(ledSignal,LOW);                  //Turn off the LED
  }
}
