// The DIY Life
// Michael Klements
// 04/05/2017

#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
  #include <avr/power.h>
#endif

int pin = 0;  //Which pin is the Neopixels attached to

int numPixels = 12;  //How many NeoPixels are attached to the Arduino

Adafruit_NeoPixel pixels = Adafruit_NeoPixel(numPixels, pin, NEO_GRB + NEO_KHZ800); //When we create the pixels object, we need to tell it how many pixels there are and which pin it is connected to.

void setup()
{
  pixels.begin();
}

void loop()
{
  for (int i=0 ; i<numPixels ; i++)
  {
    pixels.setPixelColor(i, pixels.Color(255,255,255));   //Send RGB colour values for white
    pixels.show(); //Change the LED ring to the selected colour
    delay(1000);
  }
  for (int i=0 ; i<NUMPIXELS ; i++)
  {
    pixels.setPixelColor(i, pixels.Color(0,0,0)); //Send RGB colour values for black/off
    pixels.show();
    delay(1000);
  }
}
