// Michael Klements
// Ultrasonic Sensor
// 24 August 2017
// www.the-diy-life.com

int triggerPin = 9;      //Define IO pins
int echoPin = 8;

long duration;
double distance;

void setup()
{
  pinMode(trigerPin, OUTPUT);   //Define pin
  pinMode(echoPin, INPUT);
  Serial.begin(9600);           //Starts the serial communication
}

void loop()
{
  digitalWrite(triggerPin, LOW);   //Reset the trigger pin
  delay(1000);
  digitalWrite(trigPin, HIGH);     //Create a 10 micro second pulse
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
  duration = pulseIn(echoPin, HIGH); //Read the pulse travel time in microseconds.
  distance= duration*0.034/2;        //Calculate the distance - speed of sound is 0.034 cm per microsecond
  Serial.print("Distance: ");        //Display the distance on the serial monitor
  Serial.println(distance);
}

#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 10, 5, 4, 3, 2);

void setup()
{
  lcd.begin(16,2);              // Defines the number of characters and rows
  lcd.clear();                  // Clear the screen
  lcd.setCursor(0,0);           // Set the cursor to first character, first row
  lcd.print("The DIY Life");     // Display this text
}

void loop()
{
  for (int i=0;i<=100;i++)
  {
    lcd.setCursor(0,1);           // set cursor to column 0, row 1
    lcd.print(i);                 //Display the number i
    delay(1000);
  }
}
