//Michael Klements
//The DIY Life
//26 February 2017
//7 September 2017 Modified by Filip Ledoux
//V2.2
//Serial Display 20x4
//Ethernet 

#include <Wire.h>
#include <LiquidCrystal_PCF8574.h>
#include <EEPROM.h>
#include <SPI.h>
#include <Ethernet.h>

LiquidCrystal_PCF8574 lcd(0x27);        // set the LCD address to 0x27 for a 16 chars and 2 line display

int show;

int currentPins[3] = {1,2,3};          //Assign phase CT inputs to analog pins
double calib[3] = {335.0,335.0,335.0};
double kilos[3];
unsigned long startMillis[3];
unsigned long endMillis[3];
double RMSCurrent[3];
int RMSPower[3];
int peakPower[3];

// Enter a MAC address and IP address for your controller below.
// The IP address will be dependent on your local network:
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xEB };
IPAddress ip(192,168,1,12);
IPAddress gateway(192,168,1,1);
IPAddress subnet(255, 255, 255, 0);

// Initialize the Ethernet server library with the IP address and port you want to use (port 80 is default for HTTP):
EthernetServer server(80);

void setup() 
{ 
  Serial.begin (9600);         // set the serial monitor tx and rx speed
  EEPROM.read (1);             // make the eeprom or atmega328 memory address 1

  // start the Ethernet connection and the server:  
  Ethernet.begin(mac, ip, gateway, subnet);
  server.begin();
  Serial.print("server is at ");
  Serial.println(Ethernet.localIP());
    
  int error;
  
  lcd.begin(20, 4);          // initialize the lcd
  show = 0;

  lcd.clear();
  lcd.setBacklight(255);
  lcd.home();
  lcd.setCursor(0,0);         // set cursor to column 0, row 0 
  lcd.print("3 Phase");
  lcd.setCursor(0,1);
  lcd.print("Energy Meter");
  lcd.setCursor(0,2);
  lcd.print("IP");
  lcd.setCursor(3,2);
  lcd.print(Ethernet.localIP());
  lcd.setCursor(0,3);
  lcd.print("V2.2");
  delay(2000);
}

void readPhase ()      //Method to read information from CTs
{
  for(int i=0;i<=2;i++)
  {
    int current = 0;
    int maxCurrent = 0;
    int minCurrent = 1000;
    for (int j=0 ; j<=200 ; j++)  //Monitors and logs the current input for 200 cycles to determine max and min current
    {
      current =  analogRead(currentPins[i]);  //Reads current input and records maximum and minimum current
      if(current >= maxCurrent)
        maxCurrent = current;
      else if(current <= minCurrent)
        minCurrent = current;
    }
    if (maxCurrent <= 517)
    {
      maxCurrent = 516;
    }
    RMSCurrent[i] = ((maxCurrent - 516)*0.707)/calib[i];    //Calculates RMS current based on maximum value and scales according to calibration
    RMSPower[i] = 235*RMSCurrent[i];    //Calculates RMS Power Assuming Voltage 220VAC, change to 110VAC accordingly
    if (RMSPower[i] > peakPower[i])
    {
      peakPower[i] = RMSPower[i];
    }
    endMillis[i]= millis();
    unsigned long time = (endMillis[i] - startMillis[i]);
    kilos[i] = kilos[i] + (RMSPower[i] * (time/60/60/1000000));    //Calculate kilowatt hours used
    startMillis[i]= millis();
  }
}

void loop() //Calls the methods to read values from CTs and changes display
{
  readPhase();
  displayKilowattHours ();
  delay(3000);
  readPhase();
  displayCurrent ();
  delay(3000);
  readPhase();
  displayRMSPower ();
  delay(3000);
  readPhase();
  displayPeakPower ();
  delay(3000);
}

void displayKilowattHours ()	//Displays all kilowatt hours data
{
  lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("L1->");  
  lcd.setCursor(5,0);
  lcd.print(kilos[0]);
  lcd.print("kWh");
    lcd.setCursor(0,1);
    lcd.print("L2->");
  lcd.setCursor(5,1);
  lcd.print(kilos[1]);
  lcd.print("kWh");
    lcd.setCursor(0,2);
    lcd.print("L3->");
  lcd.setCursor(5,2);
  lcd.print(kilos[2]);
  lcd.print("kWh");
  lcd.setCursor(5,3);
  lcd.print("Energy");
}

void displayCurrent ()	//Displays all current data
{
  lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("L1->"); 
  lcd.setCursor(5,0);
  lcd.print(RMSCurrent[0]);
  lcd.print("A");
    lcd.setCursor(0,1);
    lcd.print("L2->");
  lcd.setCursor(5,1);
  lcd.print(RMSCurrent[1]);
  lcd.print("A");
    lcd.setCursor(0,2);
    lcd.print("L3->");
  lcd.setCursor(5,2);
  lcd.print(RMSCurrent[2]);
  lcd.print("A");
  lcd.setCursor(5,3);
  lcd.print("Current");
}

void displayRMSPower ()	//Displays all RMS power data
{
  lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("L1->");
  lcd.setCursor(5,0);
  lcd.print(RMSPower[0]);
  lcd.print("W");
    lcd.setCursor(0,1);
    lcd.print("L2->");
  lcd.setCursor(5,1);
  lcd.print(RMSPower[1]);
  lcd.print("W");
     lcd.setCursor(0,2);
    lcd.print("L3->");
  lcd.setCursor(5,2);
  lcd.print(RMSPower[2]);
  lcd.print("W");
  lcd.setCursor(5,3);
  lcd.print("Power");
}

void displayPeakPower ()   //Displays all peak power data
{
  lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("L1->");
  lcd.setCursor(5,0);
  lcd.print(peakPower[0]);
  lcd.print("W");
    lcd.setCursor(0,1);
    lcd.print("L2->");
  lcd.setCursor(5,1);
  lcd.print(peakPower[1]);
  lcd.print("W");
    lcd.setCursor(0,2);
    lcd.print("L3->");
  lcd.setCursor(5,2);
  lcd.print(peakPower[2]);
  lcd.print("W");
  lcd.setCursor(5,3);
  lcd.print("Max Power");

 // listen for incoming clients
EthernetClient client = server.available();
  if (client) {
    Serial.println("new client");
    // an http request ends with a blank line
    boolean currentLineIsBlank = true;
    while (client.connected()) {
      if (client.available()) {
        char c = client.read();

     Serial.write(c);
        // if you've gotten to the end of the line (received a newline
        // character) and the line is blank, the http request has ended,
        // so you can send a reply
        if (c == '\n' && currentLineIsBlank) {

              
          // send a standard http response header
          client.println("HTTP/1.1 200 OK");
          client.println("Content-Type: text/html");
          client.println();
          client.println("<HTML>");
          client.println("<HEAD>");
          client.print("<meta http-equiv=\"refresh\" content=\"2\">");//refresh page every 2 sec
          client.print("<TITLE />Zoomkat's meta-refresh test</title>");
          client.println();
          client.println("<!DOCTYPE HTML>");
          client.println("<html>");
          //client.println("<FONT SIZE=12>");
          client.println("<BODY TEXT=black BGCOLOR=white>");
          client.println("<b>""Energy Display""</b>");
          client.println("<hr />");
         

          
          client.println("<mark>""RMS current:""</mark>");
          client.println("<p>");
          client.println("<b>""L1:""</b>");
          client.println( RMSCurrent[0]);
          client.println("<p>");
          client.println("<b>""L2:""</b>");          
          client.println( RMSCurrent[1]);
          client.println("<p>");
          client.println("<b>""L3:""</b>");
          client.println( RMSCurrent[2]);
          client.println("<hr />");
          
          client.println("<mark>""KWH:""</mark>");
            client.println("<p>");
          client.println("<b>""L1:""</b>");
          client.println( kilos[0]);
          client.println("<p>");
          client.println("<b>""L2:""</b>");
          client.println( kilos[1]);
            client.println("<p>");
          client.println("<b>""L3:""</b>");
          client.println( kilos[2]);
          client.println("<hr />");

          client.println("<mark>""RMS power:""</mark>");
            client.println("<p>");
           client.println("<b>""L1:""</b>");
          client.println( RMSPower[0]);
          client.println("<p>");
          client.println("<b>""L2:""</b>");
          client.println( RMSPower[1]);
            client.println("<p>");
          client.println("<b>""L3:""</b>");
          client.println( RMSPower[2]);
          client.println("<hr />");

          client.println("<mark>""MAX power:""</mark>");
            client.println("<p>");
           client.println("<b>""L1:""</b>");
          client.println( peakPower[0]);
          client.println("<p>");
          client.println("<b>""L2:""</b>");
          client.println( peakPower[1]);
            client.println("<p>");
          client.println("<b>""L3:""</b>");
          client.println( peakPower[2]);
          client.println("<hr />");

      

      
          
   // give the web browser time to receive the data
   delay(100);
// close the connection:
   client.stop();
Serial.println("client disconnected");
       
      }
    }
  }
    }
}

