//The DIY Life
//Temperature & Pressure Example
//25 July 2020

#include "DHT.h"                                                          //Import the required libraries for the sensor and OLED display
#include <Arduino.h>
#include <U8x8lib.h>

#define DHTPIN 3                                                          //DHT Sensor Pin
#define DHTTYPE DHT11                                                     //DHT 11 Temperature & Humidity Sensor
DHT dht(DHTPIN, DHTTYPE);

int potPin = A0;                                                          //Set the potentiometer pin number
int ledPin = 4;                                                           //Set the LED pin number
int buzzerPin = 5;                                                        //Set the buzzer pin number

U8X8_SSD1306_128X64_ALT0_HW_I2C u8x8(/* reset=*/ U8X8_PIN_NONE);          //Create an object to control the OLED display

int setPoint = 0;                                                         //Variable for the target temperature
int alertRange = 5;                                                       //Range above or below the target to light up the LED
int alarmRange = 10;                                                      //Range above or below the target to sound the alarm buzzer

void setup(void) 
{
  pinMode(ledPin, OUTPUT);                                                //Define the component pin modes
  pinMode(potPin, INPUT);
  pinMode(buzzerPin, OUTPUT);
  dht.begin();                                                            //Connect to the DHT Sensor
  u8x8.begin();                                                           //Connect to the OLED display
  u8x8.setPowerSave(0);                                                   //Set the display modes
  u8x8.setFlipMode(1);
}

void loop(void) 
{
  float temp, humi;                                                       //Create variables to store the temperature & humidity
  temp = dht.readTemperature();                                           //Read in the current temperature
  humi = dht.readHumidity();                                              //Read in the current humidity
  setPoint = map(analogRead(potPin),0,1023,0,50);                         //Read in the pot value and scale it to a temperature range of 0-50C

  if (temp >= setPoint+alertRange || temp <= setPoint-alertRange)         //If the temperature reading is above or below the alert range, turn on the LED
  {
    digitalWrite(ledPin, HIGH);
  }
  else
  {
    digitalWrite(ledPin, LOW);
  }

  if (temp >= setPoint+alarmRange || temp <= setPoint-alarmRange)         //If the temperature reading is above or below the alarm range, sound the buzzer
  {
    analogWrite(buzzerPin, 150);
  }
  else
  {
    analogWrite(buzzerPin, 0);
  }
  
  u8x8.setFont(u8x8_font_chroma48medium8_r);                              //Set the display font
  u8x8.setCursor(0, 33);                                                  //Set the cursor positions and display the text
  u8x8.print("T:");
  u8x8.print(int(temp));
  u8x8.print("C ");
  u8x8.print("H:");
  u8x8.print(int(humi));
  u8x8.print("%");
  u8x8.setCursor(0,50);
  u8x8.print("T Set: ");
  u8x8.print(setPoint);
  u8x8.print("C");
  u8x8.refreshDisplay();
  
  delay(200);                                                               //Wait 200 milliseconds between updates
}
