//The DIY Life
//Michael Klements
//31 July 2020

#include <SPI.h>                                  //Import the libraries required for the display and low power mode
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <LowPower.h>

#define SCREEN_WIDTH  128                         //OLED display width, in pixels
#define SCREEN_HEIGHT 32                          //OLED display height, in pixels

#define OLED_RESET     -1                         //Reset pin # (or -1 if sharing Arduino reset pin)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET); //Create the display object

#define statusLED 4                               //Define the LED & sensor pins
#define lowLED 5
#define highLED 6
#define sensorPin 10

#define dryCal 1000                               //Define the wet and dry calibration limits
#define wetCal 500

#define buttonPin 2                               //Define the button pin number

#define moisturePin A0                            //Define the analog input pin numbers
#define lowSetPin A1
#define highSetPin A2

int moisture = 0;                                 //Create variables for the analog inputs
int lowSet = 0;
int highSet = 0;

int cycleCount = 0;                               //Create a counter to flash the status LED

void setup() 
{
  Serial.begin(9600);
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);      //Connect to the display
  display.clearDisplay();                         //Clear the display
  display.setTextSize(1);                         //Normal 1:1 pixel scale
  display.setTextColor(SSD1306_WHITE);            //Draw white text
  display.setCursor(10,5);                        //Display splash screen
  display.print(F("The DIY Life"));
  display.setCursor(10,15);
  display.print(F("Soil Moisture Meter"));
  display.display();
  delay(2000);
  display.clearDisplay();                         //Clear display
  display.display();
  pinMode(statusLED, OUTPUT);                     //Set the pin modes
  pinMode(lowLED, OUTPUT);
  pinMode(highLED, OUTPUT);
  pinMode(sensorPin, OUTPUT);
  pinMode(buttonPin, INPUT);
}

void loop()
{
  updateValues();                                 //Call the function to update the analog input values
  if (digitalRead(buttonPin) == HIGH)             //If the button is pushed
  {
    while(digitalRead(buttonPin) == HIGH)         //While the button stays pushed
    {
      display.clearDisplay();                     //Display the analog input values
      display.setCursor(10,3);
      display.print(F("Moisture: "));
      display.print(moisture);
      display.print(F("%"));
      display.setCursor(10,13);
      display.print(F("Low Setpoint: "));
      display.print(lowSet);
      display.print(F("%"));
      display.setCursor(10,23);
      display.print(F("High Setpoint: "));
      display.print(highSet);
      display.print(F("%"));
      display.display();
      delay(1000);                                //Wait 1000ms between each display update
      updateValues();                             //Get updated analog input values, allows pots adjustments to be seen
    }
    display.clearDisplay();                       //When button is released, clear the display to turn it off
    display.display();
  }
  if(moisture<=lowSet)                            //If the soil moisture level is low, flash the low LED
  {
    digitalWrite(lowLED, HIGH);
    delay(50);
    digitalWrite(lowLED, LOW);
  }
  if(moisture>=highSet)                           //If the soil moisture level is high, flash the high LED
  {
    digitalWrite(highLED, HIGH);
    delay(50);
    digitalWrite(highLED, LOW);
  }
  if(cycleCount>=5)                               //Every 5 cycles, flash the status LED and reset the counter
  {
    digitalWrite(statusLED, HIGH);
    delay(50);
    digitalWrite(statusLED, LOW);
    cycleCount=0;
  }
  LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF); //Enter low power mode for 8 seconds
  cycleCount++;                                   //Increment the cycle counter
}

void updateValues ()                                              //Function to update the analog input values
{
  //digitalWrite(sensorPin, HIGH);                                //LOW Power Mode - Turn the moisture sensor on
  //delay(200);                                                   //LOW Power Mode - Wait for it to power up and stabilise
  moisture = map(analogRead(moisturePin),wetCal,dryCal,100,0);    //Read the soil moisture measurement
  Serial.println(moisture);
  //delay(50);
  //digitalWrite(sensorPin, LOW);                                 //LOW Power Mode - Turn the moisture sensor off
  lowSet = map(analogRead(lowSetPin),0,1023,0,100);               //Read in the low setpoint pot value
  if (lowSet>=highSet)                                            //Make sure that the low setpoint cannot be greater than the high
    lowSet=highSet-1;
  highSet = map(analogRead(highSetPin),0,1023,0,100);             //Read in the high setpoint pot value
  if (highSet<=lowSet)                                            //Make sure that the high setpoint cannot be less than the low
    highSet=lowSet+1;
}
