//The DIY Life
//Weather Station
//28 July 2020

#include "DHT.h"                                                          //Import the required libraries for the sensor

#define DHTPIN 10                                                         //DHT Sensor Pin
#define DHTTYPE DHT11                                                     //DHT 11 Temperature & Humidity Sensor
DHT dht(DHTPIN, DHTTYPE);

int tempPins[] = {2,3,4,5};                                               //Define the temperature motor pins
int humidPins[] = {9,8,7,6};                                              //Define the humidity motor pins

int temp = 25;                                                            //Create a variable for the temperature
int stepsPerDeg = 338;                                                    //The number of motor steps for 1 degree celcius on the gear
int humid = 50;                                                           //Create a variable for the humidity
int stepsPerPer = 69;                                                     //The number of motor steps for 1 percent on the gear
int movementSpeed = 30;                                                   //The motor movement delay in milliseconds

void setup(void) 
{
  Serial.begin(9600);                                                     //Used initially to display measured values
  for (int i = 0; i <= 3; i++) 
  { 
    pinMode(tempPins[i], OUTPUT);                                         //Assign the motor pin functions
    pinMode(humidPins[i], OUTPUT);
  }
  dht.begin();                                                            //Connect to the DHT Sensor
  delay(2000);
}

void loop(void) 
{
  float startTime = millis();
  int newTemp = dht.readTemperature();                                    //Read in the current temperature
  int newHumid = dht.readHumidity();                                      //Read in the current humidity
  Serial.println(newTemp);                                                //Display values on serial monitor
  Serial.println(newHumid);
  int tempDiff = newTemp-temp;                                            //Calculate the difference between the actual indicated values
  int humidDiff = newHumid-humid;
  temp = newTemp;                                                         //Set the current values to the updated values
  humid = newHumid;
  int tempSteps = abs(stepsPerDeg*tempDiff);                              //Calculate the number of motor steps to get to the new value
  int humidSteps = abs(stepsPerPer*humidDiff);
  bool tempDir = 0;                                                       //Create variables for the motor movement directions
  bool humidDir = 0;
  if (tempDiff < 0)                                                       //Set the motor movement directions
  {
    tempDir = 1;
  }
  if (humidDiff < 0)
  {
    humidDir = 1;
  }
  moveMotors(tempSteps, tempDir, humidSteps, humidDir);                   //Call the moveMotors function to move the two motors
  float endTime = millis();
  if (endTime-startTime < 5000)                                           //Wait at least 5 seconds between updates
    delay(5000-(endTime-startTime));
}

void moveMotors(int tempSteps, bool tempDir, int humidSteps, bool humidDir)   //Function to move motors
{
  for(int i=0; i<tempSteps ; i++)                                             //Move the temperature motor the required number of steps
  {
    static byte out = 0x01;
    if (tempDir)                                                              //Set the temperature motor direction
    {
      out != 0x08 ? out = out << 1 : out = 0x01; 
    }
    else
    {
      out != 0x01 ? out = out >> 1 : out = 0x08; 
    }
    for (int i = 0; i < 4; i++)                                               //Ring out the motor movement
    {
      digitalWrite(tempPins[i], (out & (0x01 << i)) ? HIGH : LOW);
    }
    delay(movementSpeed);                                                     //Wait the delay time between steps
  }
  for(int i=0; i<humidSteps ; i++)                                            //Move the humidity motor the required number of steps
  {
    static byte out = 0x01;
    if (humidDir)                                                             //Set the humidity motor direction
    {
      out != 0x08 ? out = out << 1 : out = 0x01; 
    }
    else
    {
      out != 0x01 ? out = out >> 1 : out = 0x08;
    }
    for (int i = 0; i < 4; i++)                                               //Ring out the motor movement
    {
      digitalWrite(humidPins[i], (out & (0x01 << i)) ? HIGH : LOW);
    }
    delay(movementSpeed);                                                     //Wait the delay time between steps
  }
}
