//Parking Assistant Example Project

#include "SR04.h"                             //Import Ultrasonic Sensor Library
#include <LiquidCrystal.h>                    //Import LCD Library

#define TRIG_PIN 4                            //Define sensor pins
#define ECHO_PIN 3

SR04 sr04 = SR04(ECHO_PIN,TRIG_PIN);          //Create sensor object
LiquidCrystal lcd(7, 8, 9, 10, 11, 12);       //Create LCD object

int greenLedPin = 5;                          //Define IO pins
int redLedPin = 6;
int buttonPin = 2;

int maxDist = 80;                             //Define parking assistant parameters
long dist;
long parkDist = 20;

void setup() 
{
  lcd.begin(16, 2);                           //Start the display and display startup text
  lcd.print("Parking");
  lcd.setCursor(0,1);
  lcd.print("Assistant");
  pinMode(greenLedPin, OUTPUT);               //Define IO pin functions
  pinMode(redLedPin, OUTPUT);
  pinMode(buttonPin, INPUT_PULLUP); 
  delay(2000);
  lcd.clear();                                //Clear the startup text
}

void loop() 
{
  boolean tooClose = false;
  dist = sr04.Distance();                                       //Measure the distance to an object
  lcd.print("Distance");                                        //Display the measurement
  lcd.setCursor(0,1);
  lcd.print(dist);
  lcd.print("cm");
  if(dist >= maxDist)                                           //Define the parking distance limits for the LED
    dist = maxDist;
  else if(dist <= parkDist)
  {
    dist = parkDist;
    tooClose = true;
  }
  analogWrite(greenLedPin, map(dist,parkDist,maxDist,0,255));   //Display the object distance on the RGB LED
  analogWrite(redLedPin, map(dist,parkDist,maxDist,255,0));
  if (tooClose)
  {
    digitalWrite(redLedPin, HIGH);
    delay(250);
    digitalWrite(redLedPin, LOW);
    delay(250);
  }
  if (digitalRead(buttonPin) == LOW)                            //Set the new parking distance if the button is pushed
  {
    parkDist = dist;
    digitalWrite(greenLedPin, HIGH);                            //Flash LED to indicate new distance has been set
    delay(500);
    digitalWrite(greenLedPin, LOW);
    digitalWrite(redLedPin, HIGH);
    delay(500);
    digitalWrite(redLedPin, LOW);
  }
  delay(500);
  lcd.clear();                                                  //Clear the display
}
