//The DIY Life
//Michael Klements
//https://www.the-diy-life.com/diy-motorised-camera-slider-with-object-tracking/
//https://www.instructables.com/Make-a-Motorised-Pan-and-Rotate-Camera-Slider/
//13 January 2021
//Modificada libreria Oled 1,3" y traducido A.Trenado Marzo-2021
//10 Marzo 2021


#include <SPI.h>                            //Import libraries to control the OLED display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SH1106.h>               
#include <math.h>

#define OLED_RESET 4                        
Adafruit_SH1106 display(OLED_RESET);

#define SCREEN_WIDTH 128                    // OLED ancho de la pantalla en pixels
#define SCREEN_HEIGHT 64                    // OLED alto de la pantalla en pixels


#define minTravDist 25                      //Definir el ajuste inicial, mínimo de la distancia de recorrido en mm
#define maxTravDist 350                     //Definir el ajuste inicial, máximo de la distancia de recorrido en mm
#define travDistInc 25                      //Definir el ajuste inicial, de incremento de la distancia de recorrido
#define initialDur 120                      //Definir el ajuste inicial de duración, mínimo, máximo e incremento.
#define minDur 10                           //Definir el ajuste inicial de duración, mínimo.
#define maxDur 1800                         //Definir el ajuste inicial de duración, máximo.
#define durInc 5                            //Definir el ajuste inicial de incremento.
#define initialRotAng 180                   //Definir el ajuste inicial de rotación, mínimo, máximo e incremento.
#define minRotAng 20                        //Angulo mínimo de rotación
#define maxRotAng 360                       //Angulo máximo de rotación
#define rotAngInc 10                        //Angulo inicial de rotación
#define initialObjDist 200                  //Definir el ajuste inicial, de distancia al objeto
#define minObjDist 150                      //Definir el ajuste inicial, mínimo de distancia del objeto
#define maxObjDist 5000                     //Definir el ajuste inicial, máximo de distancia del objeto
#define objInc 50                           //Definir el ajuste inicial, de incremento a la distancia del objeto
#define minInterval 400                     //Tiempo mínimo de intervalo entre pulsos en microsegundos

static int pinA = 2;                        //Para Encoder pin CLK
static int pinB = 3;                        //Para Encoder pin DT
#define encButton 4                         //Para Encoder pin SW (Pulsador)
volatile byte aFlag = 0;                    //Rising edge on pinA to signal that the encoder has arrived at a detent
volatile byte bFlag = 0;                    //Rising edge on pinB to signal that the encoder has arrived at a detent (opposite direction to when aFlag is set)
volatile int encoderPos = 0;                //Current value of encoder position, constained between limits below
volatile int prevEncoderPos = 0;            //To track whether the encoder has been turned and the display needs to update
volatile byte reading = 0;                  //Stores direct value from interrupt pin
byte oldButtonState = HIGH;                 //First button state is open because of pull-up resistor
const unsigned long debounceTime = 10;      //Debounce delay time
unsigned long buttonPressTime;              //Time button has been pressed for debounce

int encLowLim = 0;                          //Variables to store the encoder limits and increment
int encHighLim = 3;
int encIncrement = 1;
int dataInputNo = 0;
int modeSelected = 0;                       //Current operating mode (Pan, Rotate, Pan & Rotate, Track Object)

#define enablePin 5                         //Define el pin Enable para los dos motores
#define travDirPin 6                        //Define el pin Dir del motor desplazamiento panoramico
#define travStepPin 7                       //Define el pin Step del motor desplazamiento panoramico
#define rotDirPin 8                         //Define el pin Dir del motor rotación
#define rotStepPin 9                        //Define el pin Step del motor rotación

float travDist = maxTravDist;               //Distancia para desplazarse a través del control deslizante en milímetros
float travTime = initialDur;                //Duración del desplazamiento para cubrir la distancia requerida en segundos
float objDist = initialObjDist;             //Distancia del objeto rastreado desde el control deslizante en milímetros
int travelDir = 0;                          //Definir las direcciones iniciales de desplazamiento y rotación.
int rotDir = 0;
int rotAngle = 180;                         //Ángulo para rotar la cámara alrededor del eje

float pulsesPerMM = 50;                     //Número de pulsos del motor para desplarse 1 mm
float pulsesPerDeg = 4.4444;                //Número de pulsos del motor para rotar 1 grado
float currentDist = 0;
float currentAngle = 0;

     
void setup()
{
  Serial.begin(9600);                                     //Inicializa el puerto serie de comunicación para verificar funcionamiento
  display.begin(SH1106_SWITCHCAPVCC, 0x3C);               //Inicializa el puerto I2C con la dirección 0x3D (for the 128x64)  

  pinMode(pinA, INPUT_PULLUP);                            //Set pinA as an input, pulled HIGH to the logic voltage
  pinMode(pinB, INPUT_PULLUP);                            //Set pinB as an input, pulled HIGH to the logic voltage
  attachInterrupt(0,PinA,RISING);                         //Set an interrupt on PinA
  attachInterrupt(1,PinB,RISING);                         //Set an interrupt on PinB
  pinMode (encButton, INPUT_PULLUP);                      //Set the encoder button as an input, pulled HIGH to the logic voltage
  pinMode(enablePin, INPUT);                              //Open circuit enable pin, disables motors
  pinMode(travDirPin, OUTPUT);                            //Define the travel stepper motor pins
  pinMode(travStepPin, OUTPUT);
  pinMode(rotDirPin, OUTPUT);                             //Define the rotation stepper motor pins
  pinMode(rotStepPin, OUTPUT);
  digitalWrite(travDirPin, HIGH);                         //Set the initial direction of motion for both motors
  digitalWrite(rotDirPin, HIGH);
  display.clearDisplay();                                 //Clear the display
  //display.setTextColor(SSD1306_WHITE);                  //Set the text colour to white. Anulado del original
  display.setTextColor(WHITE);                            //sustituye a la línea anterior
  //display.drawBitmap(0, 0, logo, 128, 64, WHITE);       //Display bitmap from array. anulado del original
  display.display();
  delay(1000);
  display.clearDisplay();                                 //Clear display
  Serial.println("Setup complete");                       //Write to serial monitor to indicate the setup function is complete     

//En las siguientes lineas se indica el autor del programa 
  display.setTextSize(1);                                 //(1) es el tamaño del texto
  display.setTextColor(WHITE);                            //WHITE, es el color del texto
  display.setCursor(10,10);                               //Coordenada inicial donde comienza a escribirse el texto
  display.print("Autor:");    
  display.setCursor(10,20);
  display.print("Michael Klements");                        
  display.setCursor(10,39);
  display.print("Actualizado:");
  display.setCursor(10,50);
  display.print(" 10 marzo 2021 "); 
  display.display();
  delay(1500);  
 
}


void loop() 
{  
  encLowLim = 0;                                            //Menú de selección de modo, 4 modos
  encHighLim = 3;
  encIncrement = 1;
  updateMainMenu();
  
  boolean confirmed = false;                                //Both used to confirm button push to select mode
  boolean pressed = false;
  encoderPos = 0;                                           //Encoder starts from 0, first menu option
  while(!confirmed)                                         //While the user has not confirmed the selection
  {
    byte buttonState = digitalRead (encButton); 
    if (buttonState != oldButtonState)
    {
      if (millis () - buttonPressTime >= debounceTime)      //Debounce button
      {
        buttonPressTime = millis ();                        //Time when button was pushed
        oldButtonState =  buttonState;                      //Remember button state for next time
        if (buttonState == LOW)
        {
          modeSelected = encoderPos;                        //If the button is pressed, accept the current digit into the guessed code
          pressed = true;
          Serial.println("Boton Pulsado");
        }
        else 
        {
          if (pressed == true)                              //Confirm the input once the button is released again
          {
            confirmed = true;
            Serial.println("Modo confirmado");
          }
        }  
      }
    }
    if(encoderPos!=prevEncoderPos)                          //Update the display if the encoder position has changed
    {
      updateMainMenu();
      prevEncoderPos=encoderPos;
    }
  }
  Serial.println("Modo seleccionado");
  if (modeSelected == 0)                                    //Run required mode function depending on selection
    runPan();
  else if (modeSelected == 1)
    runRotate ();
  else if (modeSelected == 2)
    runPanAndRotate ();
  else
    runTrack ();
}

void PinA()                                             //Rutina de servicio de interrupción del codificador rotatorio para un pin del codificador
{
  cli();                                                //Detiene las interrupciones antes de que leamos los valores de los pines
  reading = PIND & 0xC;                                 //Lea los ocho valores de los pines y luego elimine todos los valores excepto el pinA y el pinB
  if(reading == B00001100 && aFlag)                     //Compruebe que tenemos ambos pines en el tope (ALTO) y que esperamos un tope en el borde ascendente de este pasador
  {     
    if(encoderPos<=(encHighLim-encIncrement))
      encoderPos = encoderPos+encIncrement;             //Increment the encoder's position count , only when below upper limit
    else
      encoderPos = encHighLim;                          //Stop at maximum, being upper limit
    bFlag = 0;                                          //Reset flags for the next turn
    aFlag = 0;                                          //Reset flags for the next turn
  }
  else if (reading == B00000100)                        //Señal de que estamos esperando que el pinB señale la transición al tope desde la rotación libre
    bFlag = 1;
  sei();                                                //Restart interrupts
}

void PinB()                                             //Rotary encoder interrupt service routine for the other encoder pin
{
  cli();                                                //Stop interrupts happening before we read pin values
  reading = PIND & 0xC;                                 //Read all eight pin values then strip away all but pinA and pinB's values
  if (reading == B00001100 && bFlag)                    //Check that we have both pins at detent (HIGH) and that we are expecting detent on this pin's rising edge
  {
    if(encoderPos>=(encLowLim+encIncrement))
      encoderPos = encoderPos-encIncrement;             //Decrement the encoder's position count, only when above lower limit
    else
      encoderPos = encLowLim;                           //Deténgase al mínimo, siendo el límite inferior
    bFlag = 0;                                          //Reset flags for the next turn
    aFlag = 0;                                          //Reset flags for the next turn
  }
  else if (reading == B00001000)                        //Señal de que estamos esperando que el pinA señale la transición al tope desde la rotación libre
    aFlag = 1;
  sei();                                                //Restart interrupts
}

void updateMainMenu()                               //Actualiza los datos de la pantalla para el menú principal.
{
  display.clearDisplay();                           //Clear display
  display.setTextSize(1);                           //Set the text size
  display.setCursor(28,4);
  display.print(F("CAMERA SLIDER"));
  display.setCursor(25,20);                         //Set the display cursor position
  display.print(F("Panoramico"));                   //Set the display text
  display.setCursor(25,30);
  display.print(F("Giro"));
  display.setCursor(25,40);
  display.print(F("Panor & Giro"));
  display.setCursor(25,50);
  display.print(F("Seguir Objeto"));
  int selected = 0;                                 //Stores cursor vertical position to show selected item
  if (encoderPos == 0)
    selected = 20;
  else if (encoderPos == 1)
    selected = 30;
  else if (encoderPos == 2)
    selected = 40;
  else
    selected = 50;
  display.setCursor(14,selected);                    //Set the display cursor position
  display.print(F(">"));
  display.display();                                //Output the display text
}

//Ejecuta la subrutina Panoramica
void runPan ()                                      //Runs the pan mode sequence
{
  inputPanData ();                                  //Get user inputs for pan movement
  displayStart ();                                  //Muestra la secuencia de arranque y habilita los motores
  display.setCursor(38,30);
  display.print(F("Panoramico"));
  display.display();
  if (travelDir == 0)                                   //Establecer la dirección de desplazamiento del motor
    digitalWrite(travDirPin, LOW);
  else
    digitalWrite(travDirPin, HIGH);
  int travelPulses = calcTravelPulses ();               //Calcule el número de pulsos del motor necesarios para mover la distancia de recorrido.
  Serial.print("Travel pulses: ");
  Serial.println(travelPulses);
  float interval = calcInterval (travelPulses);         //Calcule el intervalo de pulso requerido para mover la distancia requerida en el tiempo requerido
  Serial.print("Intervalo: ");
  Serial.println(interval);
  for (int i=1; i<=travelPulses; i++)                   //Pulse el motor para mover la distancia requerida en el tiempo requerido
  {
      digitalWrite(travStepPin, HIGH);
      delayMicroseconds(interval/2);
      digitalWrite(travStepPin, LOW);
      delayMicroseconds(interval/2);
  }
  displayEnd();                                         //Display the end sequence and disable motors
  // digitalWrite(enablePin, LOW);                      //PRUEBA XXXXXXXXXXXXXX se introduce esta linea para probar si los motores realmente se desactivan
}

//Ejecuta la subrutina Rotar
void runRotate ()                                       //Ejecuta la secuencia del modo de rotación
{
  inputRotateData ();                                   //Get user inputs for pan movement
  displayStart ();                                      //Display startup sequence and enable motors
  display.setCursor(44,30);
  display.print(F("Girando"));
  display.display();
  if (rotDir == 0)                                      //Set motor travel direction
    digitalWrite(rotDirPin, HIGH);
  else
    digitalWrite(rotDirPin, LOW);
  int rotationPulses = calcRotationPulses ();           //Calcule el número de pulsos del motor necesarios para rotar el ángulo requerido
  Serial.print("Pulsos giro: ");
  Serial.println(rotationPulses);
  Serial.print("Travel Time: ");
  Serial.println(travTime);
  float interval = calcRotInterval (rotationPulses);    //Calcule el intervalo de pulso requerido para rotar en el tiempo requerido
  Serial.print("Intervalo: ");
  Serial.println(interval);
  for (int i=1; i<=rotationPulses; i++)                 //Pulse el motor para girar el ángulo requerido en el tiempo requerido
  {
      digitalWrite(rotStepPin, HIGH);
      delay(interval/2);
      digitalWrite(rotStepPin, LOW);
      delay(interval/2);
  }
  displayEnd();                                         //Mostrar la secuencia final y deshabilitar motores
 
  }

//Ejecuta la subrutina Panoramica y giro

void runPanAndRotate ()                                       //Ejecuta la secuencia de modo de giro y giro
{
  inputPanAndRotateData ();                                   //Obtenga entradas del usuario para el movimiento de la bandeja
  displayStart ();                                            //Muestra la secuencia de arranque y habilita los motores
  display.setCursor(25,30);
  display.print(F("Panorama y Gira"));
  display.display();
  if (travelDir == 0)                                         //Set motor travel direction
    digitalWrite(travDirPin, LOW);
  else
    digitalWrite(travDirPin, HIGH);
  if (rotDir == 0)                                            //Set motor travel direction
    digitalWrite(rotDirPin, HIGH);
  else
    digitalWrite(rotDirPin, LOW);
  int travelPulses = calcTravelPulses ();                     //Calcule el número de pulsos del motor necesarios para mover la distancia de recorrido.
  Serial.print("Travel pulses: ");
  Serial.println(travelPulses);
  float interval = calcInterval (travelPulses);               //Calculate the pulse interval required to move the required distance in the required time
  Serial.print("Intervalo: ");
  Serial.println(interval);
  int rotationPulses = calcRotationPulses ();                 //Calculate the number of motor pulses required to rotate the required angle
  Serial.print("Pulsos giro: ");
  Serial.println(rotationPulses);
  int travelPerRotation = travelPulses/rotationPulses;        //Calculate how much the camera should pan for each rotation step
  for (int i=1; i<=travelPulses; i++)
  {
      digitalWrite(travStepPin, HIGH);
      int checkRotate = i % travelPerRotation;                //Compruebe si se debe realizar un paso de rotación
      if (checkRotate == 0)
        digitalWrite(rotStepPin, HIGH);
      delayMicroseconds(interval/2);
      digitalWrite(travStepPin, LOW);
      if (checkRotate == 0)
        digitalWrite(rotStepPin, LOW);
      delayMicroseconds(interval/2);
      /*currentDist = i/pulsesPerMM;
      currentAngle = i/pulsesPerDeg;
      Serial.print("Dist: ");
      Serial.println(currentDist);
      Serial.print("Angle: ");
      Serial.println(currentAngle);*/
  }
  displayEnd();                                                 //Display the end sequence and disable motors
}

//Ejecuta la subrutina Seguimiento

void runTrack ()                                                //Ejecuta la secuencia del modo de seguimiento de objetos.
{
  inputTrackData ();                                            //Obtenga entradas del usuario para rastrear el movimiento
  displayStart ();
  display.setCursor(20,30);
  display.print(F("Siguiendo Objeto"));
  display.display();
  if (travelDir == 0)                                           //Establecer el recorrido del motor y girar las direcciones
  {
    digitalWrite(travDirPin, LOW);
    digitalWrite(rotDirPin, LOW);
  }
  else
  {
    digitalWrite(travDirPin, HIGH);
    digitalWrite(rotDirPin, HIGH);
  }
  int travelPulses = calcTravelPulses ();                       //Calculates the number of pulses required to move the travel distance
  Serial.print("Travel pulses: ");
  Serial.println(travelPulses);
  float interval = calcInterval (travelPulses);                 //Calculates the interval required to achieve the required duration
  Serial.print("Intervalo: ");
  Serial.println(interval);
  currentAngle = atan((objDist)/(travDist/2))*180/M_PI;         //Calcula el ángulo inicial de la cámara al objeto
  Serial.print("Angulo Actual: ");
  Serial.println(currentAngle);
  for (int i=1; i<=(travelPulses/2); i++)                        //Runs through movement sequence to move motors
  {
      digitalWrite(travStepPin, HIGH);
      boolean rotatePulse = checkRot (i);
      if (rotatePulse == true)
        digitalWrite(rotStepPin, HIGH);
      delayMicroseconds(interval/2);
      digitalWrite(travStepPin, LOW);
      if (rotatePulse == true)
        digitalWrite(rotStepPin, LOW);
      delayMicroseconds(interval/2);
      currentDist = i/pulsesPerMM;
      /*Serial.print("Dist: ");
      Serial.println(currentDist);
      Serial.print("Angle: ");
      Serial.println(currentAngle);*/
  }
  currentAngle = 90;
  for (int i=((travelPulses/2)+1); i<=travelPulses; i++)         //Corre a través de la secuencia de movimiento para girar motores.
  {
      digitalWrite(travStepPin, HIGH);
      boolean rotatePulse = checkRot (i);
      if (rotatePulse == true)
        digitalWrite(rotStepPin, HIGH);
      delayMicroseconds(interval/2);
      digitalWrite(travStepPin, LOW);
      if (rotatePulse == true)
        digitalWrite(rotStepPin, LOW);
      delayMicroseconds(interval/2);
      currentDist = i/pulsesPerMM;
      /*Serial.print("Dist: ");
      Serial.println(currentDist);
      Serial.print("Angle: ");
      Serial.println(currentAngle);*/
  }
  displayEnd();                                           //Visualiza final de secuencia y desastiva motores
}

void displayStart()
{
  display.clearDisplay();                                   //Clear display
  display.setTextSize(1);                                   //Set the text size
  display.setCursor(30,20);                                 //Set the display cursor position
  display.print(F("Pulsar para"));                          //Set the display text
  display.setCursor(40,32);
  display.print(F("COMENZAR"));
  display.display();                                        //Output the display text
  boolean confirmed = false;                                //Both used to confirm button push to select mode
  boolean pressed = false;
  while(!confirmed)                                         //While the user has not started the panning routine
  {
    byte buttonState = digitalRead (encButton); 
    if (buttonState != oldButtonState)
    {
      if (millis () - buttonPressTime >= debounceTime)      //Debounce button
      {
        buttonPressTime = millis ();                        //Time when button was pushed
        oldButtonState =  buttonState;                      //Remember button state for next time
        if (buttonState == LOW)
        {
          pressed = true;
        }
        else 
        {
          if (pressed == true)                              //Confirm the input once the button is released again
          {
            confirmed = true;
          }
        }  
      }
    }
  }
  pinMode(enablePin, OUTPUT);                               //Enable the motors
  for(int i=3 ; i> 0 ; i--)                                 //Countdown to start
  {
    display.clearDisplay();                                 //Clear display
    display.setTextSize(3);                                 //Set the text size
    display.setCursor(60,20);                               //Set the display cursor position
    display.print(i);                                       //Set the display text
    display.display(); 
    delay(1000);
  }
  display.clearDisplay();                                   //Clear display
  display.setTextSize(1);                                   //Set the text size
  display.setCursor(25,15);                                 //Set the display cursor position
  display.print(F("-- MOVIENDO --"));                       //Set the display text
  display.display();
}

void displayEnd()
{
  display.clearDisplay();                                   //Clear display
  display.setTextSize(1);                                   //Set the text size
  display.setCursor(38,15);                                 //Set the display cursor position
  display.print(F("COMPLETO!!"));                           //Set the display text
  display.setCursor(48,35);
  display.print(F("Pulsar"));
  display.setCursor(20,47);
  display.print(F("Liberando Motores"));
  display.display();                                        //Output the display text
  boolean confirmed = false;                                //Both used to confirm button push to select mode
  boolean pressed = false;
  while(!confirmed)                                         //While the user has not started the routine
  {
    byte buttonState = digitalRead (encButton); 
    if (buttonState != oldButtonState)
    {
      if (millis () - buttonPressTime >= debounceTime)      //Debounce button
      {
        buttonPressTime = millis ();                        //Time when button was pushed
        oldButtonState =  buttonState;                      //Remember button state for next time
        if (buttonState == LOW)
        {
          pressed = true;
        }
        else 
        {
          if (pressed == true)                              //Confirm the input once the button is released again
          {
            confirmed = true;
          }
        }  
      }
    }
  }
  pinMode(enablePin, INPUT);                                //Open circuit enable pin, disables motors
  resetVariables ();
}

void inputPanData ()                                                              //Input required data for pan mode
{
  dataInputNo = 0;                                                                //Input travel distance
  inputField (maxTravDist, minTravDist, maxTravDist, travDistInc);
  dataInputNo = 1;                                                                //Input travel direction
  inputField (0, 0, 1, 1);
  dataInputNo = 2;                                                                //Input travel duration
  inputField (initialDur, minDur, maxDur, durInc);
}

void inputRotateData ()                                                           //Input required data for rotate mode
{
  dataInputNo = 0;                                                                //Input rotation angle
  inputField (initialRotAng, minRotAng, maxRotAng, rotAngInc);
  dataInputNo = 1;                                                                //Input rotation direction
  inputField (0, 0, 1, 1);
  dataInputNo = 2;                                                                //Input rotation duration
  inputField (initialDur, minDur, maxDur, durInc);
}

void inputPanAndRotateData ()                                                     //Input required data for pan and rotate mode
{
  dataInputNo = 0;                                                                //Input pan distance
  inputField (maxTravDist, minTravDist, maxTravDist, travDistInc);
  dataInputNo = 1;                                                                //Input pan direction
  inputField (0, 0, 1, 1);
  dataInputNo = 2;                                                                //Input rotation angle
  inputField (initialRotAng, minRotAng, maxRotAng, rotAngInc);
  dataInputNo = 3;                                                                //Input rotation direction
  inputField (0, 0, 1, 1);
  dataInputNo = 4;                                                                //Input total duration
  inputField (initialDur, minDur, maxDur, durInc);
}

void inputTrackData ()                                                            //Input required data for object tracking mode
{
  dataInputNo = 0;                                                                //Input pan distance
  inputField (maxTravDist, minTravDist, maxTravDist, travDistInc);
  dataInputNo = 1;                                                                //Input pan direction
  inputField (0, 0, 1, 1);
  dataInputNo = 2;                                                                //Input rotation angle
  inputField (initialObjDist, minObjDist, maxObjDist, objInc);
  dataInputNo = 3;                                                                //Input total duration
  inputField (initialDur, minDur, maxDur, durInc);
}

void updatePanDataDisplay ()
{
  display.clearDisplay();                                   //Clear display
  display.setTextSize(1);                                   //Set the text size
  display.setCursor(2,10);                                  //Set the display cursor position
  display.print(F("Distancia: "));                          //Set the display text
  display.setCursor(2,20);
  display.print(F("Direccion: "));
  display.setCursor(2,30);
  display.print(F("Duracion: "));
  int selected = 0;
  if (dataInputNo == 0)                                     //Get the cursor position & update changing variable
  {
    selected = 10;
    travDist = encoderPos;
  }
  else if (dataInputNo == 1)
  {
    selected = 20;
    travelDir = encoderPos;
  }
  else
  {
    selected = 30;
    travTime = encoderPos;
    if(calcInterval (calcTravelPulses ()) < minInterval)    //Flags movement too fast
    {
      display.setCursor(07,55);                             //Set the display cursor position
      display.print(F("Demasiado Rapido!!"));               //Set the display text
    }
  }
  display.setCursor(65,selected);                           //Set the display cursor position
  display.print(F(">"));
  display.setCursor(75,10);                                 //Display the field data
  display.print(travDist);
  display.print(F("mm"));
  display.setCursor(75,20);
  if (travelDir == 0)
    display.print(F("Adelante"));
  else
    display.print(F("Atras"));
  display.setCursor(75,30);
  display.print(travTime);
  display.print(F("s"));
  display.display();                                        //Output the display text
}

void updateRotDataDisplay ()
{
  display.clearDisplay();                                   //Clear display
  display.setTextSize(1);                                   //Set the text size
  display.setCursor(2,10);                                  //Set the display cursor position
  display.print(F("Rotacion: "));                           //Set the display text
    display.setCursor(2,20);
  display.print(F("Direccion: "));
  display.setCursor(2,30);
  display.print(F("Duracion: "));
  int selected = 0;
  if (dataInputNo == 0)                                     //Get the cursor position & update changing variable
  {
    selected = 10;
    rotAngle = encoderPos;
  }
  else if (dataInputNo == 1)
  {
    selected = 20;
    rotDir = encoderPos;
  }
  else
  {
    selected = 30;
    travTime = encoderPos;
    if(calcRotInterval (calcRotationPulses ()) < minInterval) //Flags movement too fast
    {
      display.setCursor(07,55);                               //Set the display cursor position
      display.print(F("Demasiado rapido!!"));                 //Set the display text
    }
  }
  display.setCursor(65,selected);                             //Set the display cursor position
  display.print(F(">"));
  display.setCursor(75,10);                                   //Display the field data
  display.print(rotAngle);
  display.print(F("deg"));
  display.setCursor(75,20);
  if (rotDir == 0)
    display.print(F("Adelante"));
  else
    display.print(F("Atras"));
  display.setCursor(75,30);
  display.print(travTime);
  display.print(F("s"));
  display.display();                                        //Output the display text
}

void updatePanAndRotateDataDisplay ()
{
  display.clearDisplay();                                   //Clear display
  display.setTextSize(1);                                   //Set the text size
  display.setCursor(2,2);                                   //Set the display cursor position
  display.print(F("Distancia: "));                          //Set the display text
  display.setCursor(2,12);
  display.print(F("Direccion: "));
  display.setCursor(2,22);
  display.print(F("Rotacion.: "));
  display.setCursor(2,32);
  display.print(F("Dir. Rot.: "));
  display.setCursor(2,42);
  display.print(F("Duracion: "));
  int selected = 0;
  if (dataInputNo == 0)                                     //Get the cursor position & update changing variable
  {
    selected = 2;
    travDist = encoderPos;
  }
  else if (dataInputNo == 1)
  {
    selected = 12;
    travelDir = encoderPos;
  }
  else if (dataInputNo == 2)
  {
    selected = 22;
    rotAngle = encoderPos;
  }
  else if (dataInputNo == 3)
  {
    selected = 32;
    rotDir = encoderPos;
  }
  else
  {
    selected = 42;
    travTime = encoderPos;
    if(calcInterval (calcTravelPulses ()) < minInterval)    //Flags movement too fast
    {
      display.setCursor(07,55);                             //Set the display cursor position
      display.print(F("Demasiado rapido!!"));               //Set the display text
    }
  }
  display.setCursor(65,selected);                           //Set the display cursor position
  display.print(F(">"));
  display.setCursor(75,2);                                  //Display the field data
  display.print(travDist);
  display.print(F("mm"));
  display.setCursor(75,12);
  if (travelDir == 0)
    display.print(F("Adelante"));
  else
    display.print(F("Atras"));
  display.setCursor(75,22);
  display.print(rotAngle);
  display.print(F("deg"));
  display.setCursor(75,32);
  if (rotDir == 0)
    display.print(F("Adelante"));
  else
    display.print(F("Atras"));
  display.setCursor(75,42);
  display.print(travTime);
  display.print(F("s"));
  display.display();                                        //Output the display text
}

void updateTrackDataDisplay ()
{
  display.clearDisplay();                                   //Clear display
  display.setTextSize(1);                                   //Set the text size
  display.setCursor(2,10);                                  //Set the display cursor position
  display.print(F("Distancia: "));                          //Set the display text
  display.setCursor(2,20);
  display.print(F("Sentido: "));
  display.setCursor(2,30);
  display.print(F("Dist. Obj.: "));
  display.setCursor(2,40);
  display.print(F("Duracion: "));
  int selected = 0;
  if (dataInputNo == 0)                                     //Get the cursor position & update changing variable
  {
    selected = 10;
    travDist = encoderPos;
  }
  else if (dataInputNo == 1)
  {
    selected = 20;
    travelDir = encoderPos;
  }
  else if (dataInputNo == 2)
  {
    selected = 30;
    objDist = encoderPos;
  }
  else
  {
    selected = 40;
    travTime = encoderPos;
    if(calcInterval (calcTravelPulses ()) < minInterval)    //Flags movement too fast
    {
      display.setCursor(07,55);                             //Set the display cursor position
      display.print(F("Demasiado Rapido!!"));               //Set the display text
    }
  }
  display.setCursor(65,selected);                           //Set the display cursor position
  display.print(F(">"));
  display.setCursor(75,10);                                 //Display the field data
  display.print(travDist);
  display.print(F("mm"));
  display.setCursor(75,20);
  if (travelDir == 0)
  display.print(F("Adelante"));
  else
  display.print(F("Atras"));
  display.setCursor(75,30);
  display.print(objDist);
  display.print(F("mm"));
  display.setCursor(75,40);
  display.print(travTime);
  display.print(F("s"));
  display.display();                                        //Output the display text
}

void inputField (int initialSetting, int lowerLimit, int upperLimit, int increment)
{
  encLowLim = lowerLimit;
  encHighLim = upperLimit;
  encIncrement = increment;
  encoderPos = initialSetting;                              //Encoder starts from initial setting
  prevEncoderPos = encoderPos+1;                            //Set different so that display is updated on first cycle
  boolean confirmed = false;                                //Both used to confirm button push to select mode
  boolean pressed = false;
  while(!confirmed)                                         //While the user has not confirmed the input
  {
    byte buttonState = digitalRead (encButton); 
    if (buttonState != oldButtonState)
    {
      if (millis () - buttonPressTime >= debounceTime)      //Debounce button
      {
        buttonPressTime = millis ();                        //Time when button was pushed
        oldButtonState =  buttonState;                      //Remember button state for next time
        if (buttonState == LOW)
        {
          pressed = true;
        }
        else 
        {
          if (pressed == true)                              //Confirm the input once the button is released again
          {
            confirmed = true;
            Serial.println("Input Confirmed");
          }
        }  
      }
    }
    if(encoderPos!=prevEncoderPos)                          //Update the display if the encoder position has changed
    {
      if (modeSelected == 0)
        updatePanDataDisplay ();
      else if (modeSelected == 1)
        updateRotDataDisplay ();
      else if (modeSelected == 2)
        updatePanAndRotateDataDisplay ();
      else
        updateTrackDataDisplay ();
      prevEncoderPos=encoderPos;
    }
  }
}

void resetVariables ()                                       //Reset variables back to initial values after run
{
  travDist = maxTravDist;
  travTime = initialDur;
  objDist = initialObjDist;
  travelDir = 0;
  rotDir = 0;
  rotAngle = initialRotAng;
}

int calcTravelPulses ()                                       //Calculates the number of pulses required to move a certain distance
{
  int travP = travDist*pulsesPerMM;
  return travP;
}

int calcRotationPulses ()                                     //Calculate the number of pulses required to rotate a certain angle
{
  int rotP = rotAngle*pulsesPerDeg;
  return rotP;
}

boolean checkRot (int i)                                      //Used in tracking to calculate the angle required to track object
{
  boolean rotP = false;
  float deltaAngle;
  if(((travDist/2)-(i/pulsesPerMM)) > 0)
  {
    if (currentAngle < 90-(1/pulsesPerDeg))
    {
      float newAngle = atan((objDist)/((travDist/2)-(i/pulsesPerMM)))*180/M_PI;
      deltaAngle = newAngle-currentAngle;
    }
  }
  else if (((travDist/2)-(i/pulsesPerMM)) < 0)
  {
    if (currentAngle > 0)
    {
      float newAngle = atan((objDist)/((i/pulsesPerMM)-(travDist/2)))*180/M_PI;
      deltaAngle = currentAngle-newAngle;
    }
  }
  if(deltaAngle >= (1/pulsesPerDeg))
  {
    rotP = true;
    if ((travDist/2)-(i/pulsesPerMM) > 0)
      currentAngle=currentAngle+(1/pulsesPerDeg);
    else
      currentAngle=currentAngle-(1/pulsesPerDeg);
  }
  return rotP;
}

float calcInterval (int numPulses)                                 //Calculate the interval required between pulses to achieve duration
{
  float inter = travTime*1000000/numPulses;
  return inter;
}

float calcRotInterval (int numPulses)                              //Calculate the interval required between pulses to achieve duration
{
  float inter = travTime*1000/numPulses;
  return inter;
}
